% Median Filter Proof-of-concept code
% Coded by Qun Feng Tan
close all
clear all
clc
p = 0.5;
pic = imread('einstein_bit.jpg');
height = size(pic,1);
width = size(pic,2);
pic_vec = pic(:);
pic_mean = mean(pic_vec);
B = pic_vec>pic_mean;
img_size = numel(pic);
%---Corrupting with noise------%
Y = xor(B,(rand(img_size,1)<p));
%------Edge padding------------%
window_size=9
Y1 = [Y(1)*ones((window_size-1)/2,1);Y;Y(img_size)*ones((window_size-1)/2,1)];
%----Median filter----%
for i = 1:size(Y)
    Y1_out(i)=median([Y1(i:i+window_size-1)]);
end
output=Y1_out';
%---Reshaping image and compute error rate -----%
imshow(reshape(B,size(pic,1),size(pic,2)))
figure
imshow(reshape(Y,size(pic,1),size(pic,2)))
figure
imshow(reshape(output,size(pic,1),size(pic,2)));
orig_error_rate=mean(abs(B-Y))
post_error_rate=mean(abs(B-output))
